/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.policy.tools.processors;

import com.mulesoft.anypoint.policy.tools.processors.DecrypterTransformer;
import com.mulesoft.anypoint.policy.tools.processors.EncrypterTransformer;
import com.mulesoft.anypoint.policy.tools.processors.Processor;
import com.mulesoft.anypoint.policy.tools.processors.Transformer;
import com.mulesoft.anypoint.policy.tools.validators.InvalidArgumentsToolException;

public abstract class EncryptionProcessor
implements Processor {
    public static String ENCRYPT = "encrypt";
    public static String DECRYPT = "decrypt";
    private final Transformer transformer;

    public EncryptionProcessor(String mode, String key) throws InvalidArgumentsToolException {
        if (!mode.equals(ENCRYPT) && !mode.equals(DECRYPT)) {
            throw new InvalidArgumentsToolException(String.format("Invalid encryption mode '%s', possible values are '%s' and '%s'.", mode, ENCRYPT, DECRYPT));
        }
        if (key.length() != 16) {
            throw new InvalidArgumentsToolException(String.format("Encryption key '%s' is invalid, it must be 16 characters long.", key));
        }
        this.transformer = mode.equals(ENCRYPT) ? new EncrypterTransformer(key) : new DecrypterTransformer(key);
    }

    protected String transformString(String inputValue) {
        return this.transformer.transform(inputValue);
    }
}

