/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.api;

import com.mulesoft.modules.configuration.properties.api.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.api.EncryptionMode;
import com.mulesoft.modules.configuration.properties.internal.SecureConfigurationPropertiesProvider;
import java.util.List;
import org.mule.encryption.jce.JCE;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;

public class SecureConfigurationPropertiesProviderFactory
implements ConfigurationPropertiesProviderFactory {
    public static final String EXTENSION_NAMESPACE = "secure-properties";
    public static final String SECURE_CONFIGURATION_PROPERTIES_ELEMENT = "config";
    public static final ComponentIdentifier SECURE_CONFIGURATION_PROPERTIES = ComponentIdentifier.builder().namespace("secure-properties").name("config").build();
    private static final String SHORT_KEY_MESSAGE = "You need to increment your key size. The minimum allowed key size is: %d, but your key size is: %d";
    private static final String LONG_KEY_MESSAGE = "Your key size exceeds the maximum allowed key size in your JVM. The maximum allowed key size is: %d, but your key size is: %d.";
    private static final String INSTALL_JCE_MESSAGE = "You need to install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files";

    public ComponentIdentifier getSupportedComponentIdentifier() {
        return SECURE_CONFIGURATION_PROPERTIES;
    }

    public SecureConfigurationPropertiesProvider createProvider(ConfigurationParameters parameters, ResourceProvider externalResourceProvider) {
        String file = parameters.getStringParameter("file");
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"Required attribute 'file' of 'secure-configuration-properties' not found");
        String key = parameters.getStringParameter("key");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"Required attribute 'key' of 'secure-configuration-properties' not found");
        String encoding = this.getFileEncoding(parameters);
        ComponentIdentifier encryptComponentIdentifier = ComponentIdentifier.builder().namespace(EXTENSION_NAMESPACE).name("encrypt").build();
        EncryptionAlgorithm algorithm = this.getAlgorithm(parameters.getComplexConfigurationParameter(encryptComponentIdentifier));
        EncryptionMode mode = this.getMode(parameters.getComplexConfigurationParameter(encryptComponentIdentifier));
        boolean fileLevelEncryption = this.getFileLevelEncryption(parameters);
        this.validateKeyLength(key, algorithm);
        boolean useRandomIVs = this.getUseRandomIVs(parameters.getComplexConfigurationParameter(encryptComponentIdentifier));
        return new SecureConfigurationPropertiesProvider(externalResourceProvider, file, algorithm, key, mode, encoding, fileLevelEncryption, useRandomIVs);
    }

    private EncryptionAlgorithm getAlgorithm(List<ConfigurationParameters> encryptionParameters) {
        return EncryptionAlgorithm.valueOf(this.getProperty(encryptionParameters, "algorithm", EncryptionAlgorithm.AES.name()));
    }

    private EncryptionMode getMode(List<ConfigurationParameters> encryptionParameters) {
        return EncryptionMode.valueOf(this.getProperty(encryptionParameters, "mode", EncryptionMode.CBC.name()));
    }

    private boolean getFileLevelEncryption(ConfigurationParameters parameters) {
        try {
            return Boolean.valueOf(parameters.getStringParameter("fileLevelEncryption"));
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getFileEncoding(ConfigurationParameters parameters) {
        return parameters.getStringParameter("encoding");
    }

    private String getProperty(List<ConfigurationParameters> encryptionParameters, String property, String defaultValue) {
        if (encryptionParameters.size() != 1) {
            return defaultValue;
        }
        String propertyValue = encryptionParameters.get(0).getStringParameter(property);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    private void validateKeyLength(String key, EncryptionAlgorithm algorithm) {
        if (key.length() > algorithm.getMaxKeySize()) {
            String message = String.format(LONG_KEY_MESSAGE, algorithm.getMaxKeySize(), key.length());
            if (!JCE.isJCEInstalled()) {
                message = message + INSTALL_JCE_MESSAGE;
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message));
        }
        if (key.length() < algorithm.getMinKeySize()) {
            String message = String.format(SHORT_KEY_MESSAGE, algorithm.getMinKeySize(), key.length());
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message));
        }
    }

    private boolean getUseRandomIVs(List<ConfigurationParameters> encryptionParameters) {
        return Boolean.valueOf(this.getProperty(encryptionParameters, "useRandomIVs", "false"));
    }
}

