/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools;

import com.mulesoft.modules.configuration.properties.api.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.api.EncryptionMode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;

public class SecurePropertiesTool {
    public static final String ENCRYPTION_ACTION = "encrypt";
    public static final String DECRYPTION_ACTION = "decrypt";
    private static final String HOLE_FILE_LEVEL_TYPE = "file-level";
    private static final String FILE_TYPE = "file";
    private static final String WORD_TYPE = "string";
    private static final String YAML_FILE = ".yaml";
    private static final String PROPERTIES_FILE_SEPARATOR = "=";
    private static final String YAML_SEPARATOR = ":";
    private static final String PROPERTIES_FILE = ".properties";
    private static final char COMMENTS = '#';
    private static final char VALUE_DELIMITER = '\"';
    private static final char VALUE_ESCAPED_CHARACTER = '\\';
    private static final String VALUE_ESCAPED_DOUBLE_QUOTE = "\\\"";
    private static final Pattern encryptPattern = Pattern.compile("!\\[(.*)\\]");
    private static final String USE_RANDOM_IV = "--use-random-iv";

    private static Encrypter createEncrypter(String algorithm, String mode, String key, boolean useRandomIVs) {
        return EncryptionAlgorithm.valueOf(algorithm).getBuilder().forKey(key).using(EncryptionMode.valueOf(mode)).useRandomIVs(useRandomIVs).build();
    }

    private static String decrypt(String value, String algorithm, String mode, String key, boolean useRandomIVs) throws MuleEncryptionException {
        Encrypter encrypter = SecurePropertiesTool.createEncrypter(algorithm, mode, key, useRandomIVs);
        return new String(encrypter.decrypt(Base64.getDecoder().decode(value)));
    }

    private static String encrypt(String value, String algorithm, String mode, String key, boolean useRandomIVs) throws MuleEncryptionException {
        Encrypter encrypter = SecurePropertiesTool.createEncrypter(algorithm, mode, key, useRandomIVs);
        return new String(Base64.getEncoder().encode(encrypter.encrypt(value.getBytes())));
    }

    private static byte[] decrypt(byte[] value, String algorithm, String mode, String key, boolean useRandomIVs) throws MuleEncryptionException {
        Encrypter encrypter = SecurePropertiesTool.createEncrypter(algorithm, mode, key, useRandomIVs);
        return encrypter.decrypt(Base64.getDecoder().decode(value));
    }

    private static byte[] encrypt(byte[] value, String algorithm, String mode, String key, boolean useRandomIVs) throws MuleEncryptionException {
        Encrypter encrypter = SecurePropertiesTool.createEncrypter(algorithm, mode, key, useRandomIVs);
        return Base64.getEncoder().encode(encrypter.encrypt(value));
    }

    public static String applyOverString(String action, String algorithm, String mode, String key, boolean useRandomIVs, String value) throws MuleEncryptionException {
        if (action.equals(ENCRYPTION_ACTION)) {
            value = StringEscapeUtils.unescapeJava(value);
            return SecurePropertiesTool.encrypt(value, algorithm, mode, key, useRandomIVs);
        }
        return SecurePropertiesTool.decrypt(value, algorithm, mode, key, useRandomIVs);
    }

    private static String applyOverFileValue(String action, String algorithm, String mode, String key, boolean useRandomIVs, String value) throws MuleEncryptionException {
        if (action.equals(ENCRYPTION_ACTION)) {
            value = StringEscapeUtils.unescapeJava(value);
            return "![" + SecurePropertiesTool.encrypt(value, algorithm, mode, key, useRandomIVs) + "]";
        }
        Matcher m = encryptPattern.matcher(value);
        if (m.find()) {
            return SecurePropertiesTool.decrypt(m.group(1), algorithm, mode, key, useRandomIVs);
        }
        return value;
    }

    private static String removeComment(String line) {
        StringBuilder result = new StringBuilder();
        boolean opened = false;
        char previous = '\u0000';
        for (char c : line.toCharArray()) {
            if (c == '#' && !opened) {
                return result.toString();
            }
            result.append(c);
            if (c == '\"' && previous != '\\') {
                if (opened) {
                    return result.toString();
                }
                opened = true;
            }
            previous = c;
        }
        return result.toString();
    }

    private static String getComment(String line) {
        String result = "";
        boolean startedComment = false;
        boolean openedValue = false;
        for (char c : line.toCharArray()) {
            if (c == '#' && !openedValue) {
                startedComment = true;
            }
            if (c == '\"') {
                boolean bl = openedValue = !openedValue;
            }
            if (!startedComment) continue;
            result = result + c;
        }
        return result;
    }

    private static void processFileLine(String line, BufferedWriter writer, String action, String algorithm, String mode, String key, boolean useRandomIVs, String separator, boolean space) throws IOException, MuleEncryptionException {
        String comments = SecurePropertiesTool.getComment(line);
        if (!(line = SecurePropertiesTool.removeComment(line)).contains(separator)) {
            writer.write(comments);
            return;
        }
        String in = line.split(separator)[0];
        writer.write(in + separator);
        String value = line.substring(in.length() + 1).trim();
        if (value.length() > 0) {
            String[] splitted;
            String[] stringArray;
            if (space) {
                writer.write(" ");
            }
            if (value.contains(VALUE_ESCAPED_DOUBLE_QUOTE)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            } else {
                stringArray = splitted = value.split("\"");
            }
            if (splitted.length == 0) {
                writer.write("\"" + SecurePropertiesTool.applyOverFileValue(action, algorithm, mode, key, useRandomIVs, "") + '\"');
            } else if (splitted.length == 1) {
                writer.write(SecurePropertiesTool.applyOverFileValue(action, algorithm, mode, key, useRandomIVs, value));
            } else {
                writer.write("\"" + SecurePropertiesTool.applyOverFileValue(action, algorithm, mode, key, useRandomIVs, splitted[1]) + '\"');
            }
        }
        if (comments.length() > 0) {
            writer.write(" " + comments);
        }
    }

    public static void applyOverFile(String action, String algorithm, String mode, String key, boolean useRandomIVs, String inputFilePath, String outputFilePath) throws IOException {
        StringBuilder errorsFound = new StringBuilder();
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputFilePath, new String[0]), new OpenOption[0]);){
            Files.lines(Paths.get(inputFilePath, new String[0])).forEach(line -> {
                try {
                    if (line.trim().length() == 0) {
                        writer.write("\n");
                        return;
                    }
                    if (inputFilePath.endsWith(YAML_FILE)) {
                        SecurePropertiesTool.processFileLine(line, writer, action, algorithm, mode, key, useRandomIVs, YAML_SEPARATOR, true);
                    } else {
                        SecurePropertiesTool.processFileLine(line, writer, action, algorithm, mode, key, useRandomIVs, PROPERTIES_FILE_SEPARATOR, false);
                    }
                    writer.write("\n");
                }
                catch (MuleEncryptionException e) {
                    errorsFound.append(e.getCause().getMessage()).append(System.lineSeparator());
                }
                catch (IOException e) {
                    errorsFound.append(e.getMessage()).append(System.lineSeparator());
                }
            });
        }
        if (errorsFound.length() != 0) {
            throw new IOException(errorsFound.toString());
        }
    }

    public static void applyHoleFile(String action, String algorithm, String mode, String key, boolean useRandomIVs, String inputFilePath, String outputFilePath) throws IOException, MuleEncryptionException {
        File inputFile = new File(inputFilePath);
        FileInputStream stream = new FileInputStream(inputFile);
        byte[] bytes = IOUtils.toByteArray(stream);
        byte[] result = action.equals(ENCRYPTION_ACTION) ? SecurePropertiesTool.encrypt(bytes, algorithm, mode, key, useRandomIVs) : SecurePropertiesTool.decrypt(bytes, algorithm, mode, key, useRandomIVs);
        FileUtils.writeByteArrayToFile(new File(outputFilePath), result);
    }

    private static void usage() {
        System.err.println("Usage:");
        System.err.println("\tjava -cp secure-properties-tool.jar com.mulesoft.tools.SecurePropertiesTool string <encrypt|decrypt> <algorithm> <mode> <key> <value> --use-random-iv [optional]");
        System.err.println("\tor");
        System.err.println("\tjava -cp secure-properties-tool.jar com.mulesoft.tools.SecurePropertiesTool file <encrypt|decrypt> <algorithm> <mode> <key> <input file> <output file> --use-random-iv [optional]");
        System.err.println("\tor");
        System.err.println("\tjava -cp secure-properties-tool.jar com.mulesoft.tools.SecurePropertiesTool file-level <encrypt|decrypt> <algorithm> <mode> <key> <input file> <output file> --use-random-iv [optional]");
    }

    private static boolean extractUseRandomIVArgument(String[] args) {
        if (args != null && args.length != 0) {
            return USE_RANDOM_IV.equals(args[args.length - 1]);
        }
        return false;
    }

    private static boolean validateArguments(String[] args) {
        int minArguments;
        if (args == null || args.length == 0) {
            return false;
        }
        boolean useRandomIVs = SecurePropertiesTool.extractUseRandomIVArgument(args);
        int n = minArguments = useRandomIVs ? 7 : 6;
        if (args.length < minArguments) {
            return false;
        }
        String type = args[0];
        String action = args[1];
        String algorithm = args[2];
        String mode = args[3];
        if (!(type.equals(WORD_TYPE) || type.equals(FILE_TYPE) || type.equals(HOLE_FILE_LEVEL_TYPE))) {
            return false;
        }
        if (!action.equals(ENCRYPTION_ACTION) && !action.equals(DECRYPTION_ACTION)) {
            return false;
        }
        try {
            EncryptionAlgorithm.valueOf(algorithm);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            EncryptionMode.valueOf(mode);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (type.equals(FILE_TYPE) || type.equals(HOLE_FILE_LEVEL_TYPE)) {
            int maxArgumentsLength;
            int n2 = maxArgumentsLength = useRandomIVs ? 8 : 7;
            if (args.length != maxArgumentsLength) {
                return false;
            }
            String input = args[5];
            String output = args[6];
            return input.endsWith(YAML_FILE) && output.endsWith(YAML_FILE) || input.endsWith(PROPERTIES_FILE) && output.endsWith(PROPERTIES_FILE);
        }
        int maxArgumentsLength = useRandomIVs ? 7 : 6;
        return args.length == maxArgumentsLength;
    }

    public static void main(String[] args) {
        if (!SecurePropertiesTool.validateArguments(args)) {
            System.err.println("Invalid arguments");
            SecurePropertiesTool.usage();
            System.exit(1);
        }
        try {
            boolean useRandomIVs = SecurePropertiesTool.extractUseRandomIVArgument(args);
            String type = args[0];
            String action = args[1];
            String algorithm = args[2];
            String mode = args[3];
            String key = args[4];
            if (type.equals(WORD_TYPE)) {
                System.out.println(SecurePropertiesTool.applyOverString(action, algorithm, mode, key, useRandomIVs, args[5]));
            } else {
                String input = args[5];
                String output = args[6];
                if (type.equals(FILE_TYPE)) {
                    SecurePropertiesTool.applyOverFile(action, algorithm, mode, key, useRandomIVs, input, output);
                } else {
                    SecurePropertiesTool.applyHoleFile(action, algorithm, mode, key, useRandomIVs, input, output);
                }
            }
        }
        catch (MuleEncryptionException e) {
            System.err.println(e.getCause().getMessage());
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
    }
}

