/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal.keyfactories;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.mule.encryption.key.SymmetricKeyFactory;

public class SymmetricEncryptionKeyFactory
implements SymmetricKeyFactory {
    private String algorithm;
    private byte[] key;

    public SymmetricEncryptionKeyFactory(String algorithm, String key) {
        this.validateKey(key);
        this.algorithm = algorithm;
        this.key = key.getBytes();
    }

    @Override
    public Key encryptionKey() {
        return new SecretKeySpec(this.key, this.algorithm);
    }

    private void validateKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("If keystore is not defined then the key is considered to be an encryption key in Base64 encoding");
        }
    }
}

